	function cterm = calccterm(crep, wout, wdata, signeddata)
	%cterm = calccterm(crep, wout, wdata, signeddata)
	%
	%Calculates correction vector for a given coefficient representation,
	%data wordlength and signedness.
	%
	%Arguments:
	%  crep - coefficient representation, generated by chooserep
	%  wout - output wordlength
	%  wdata - data wordlength
	%  signeddata - signedness of data
	%
	%Returns:
	%  cterm - constant term row vector
	
	%Copyright 2008, 2010 Anton Blad
	%
	%This file is part of firgen.
	%
	%firgen is free software: you can redistribute it and/or modify
	%it under the terms of the GNU General Public License as published by
	%the Free Software Foundation, either version 3 of the License, or
	%(at your option) any later version.
	%
	%firgen is distributed in the hope that it will be useful,
	%but WITHOUT ANY WARRANTY; without even the implied warranty of
	%MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	%GNU General Public License for more details.
	%
	%You should have received a copy of the GNU General Public License
	%along with firgen.  If not, see <http://www.gnu.org/licenses/>
	
	coeffs = crep.coeffs;
	
	datasigns = zeros(1, wdata);
	if signeddata == 1
		datasigns(1) = 1;
	end
	
	pcoeffs = sum(coeffs == 1);
	ncoeffs = sum(coeffs == -1);
	
	negterm = conv(pcoeffs, datasigns) + conv(ncoeffs, 1*not(datasigns));
	
	cterm = conv(negterm, ones(1, wout));
	
	s = 0;
	for n = length(cterm):-1:1
		t = mod(cterm(n)+s, 2);
		s = (cterm(n)+s-t)/2;
		cterm(n) = t;
	end
	
	cterm = cterm(end-wout+1:end);
	
